<?php

namespace MSML\Tables\Http\Controllers;

use App\Http\Controllers\Controller;
use MSML\Tables\Http\Requests\TableRequest;
use Illuminate\Http\Resources\Json\JsonResource;
use Illuminate\Http\Resources\Json\ResourceCollection;
use MSML\Tables\Table;

class TableController
{
    public function __invoke(TableRequest $request, Table $table): ResourceCollection
    {
        $paginatedData = $table->query($request)->orderByDesc('id')->paginate($request->integer('limit'));

        return JsonResource::collection($paginatedData->through($table->resource(...)));
    }
}
