<?php

namespace MSML\Tables;

use ArrayObject;
use Illuminate\Support\Str;
use Illuminate\Http\Request;
use Illuminate\Support\Collection;
use Illuminate\Database\Eloquent\Builder;
use MSML\Tables\Interfaces\Exportable;

abstract class Table
{
    protected bool $multiSortEnabled = false;

    abstract public function authorize(): bool;

    abstract public function query(Request $request): Builder;

    abstract public function resource(mixed $item): array;

    abstract protected function defineColumns(): array;

    public function columns(): array
    {
        return $this->defineColumns();
    }

    protected function getPageSize(): int
    {
        return 15;
    }

    public function toArray(): array
    {
        return [
            'name'       => static::name(),
            'columns'    => $this->columns(),
            'pageSize'   => $this->getPageSize(),
            'multiSort'  => $this->multiSortEnabled,
            'exportable' => is_a(static::class, Exportable::class, true),
        ];
    }

    public static function name(): string
    {
        return static::$name ?? Str::snake(class_basename(static::class), '-');
    }

    protected static function filterVariants(): FilterVariants
    {
        return new FilterVariants;
    }

    protected static function filterFunctions(): FilterFunctions
    {
        return new FilterFunctions;
    }

    protected static function formatTo(): FormatTo
    {
        return new FormatTo;
    }

    protected static function prepareSelectData(array|Collection $data, string|null $valueKey = 'id', string|null $labelKey = 'name'): array
    {
        return collect($data)->transform(fn ($item) => [
            'value' => $valueKey ? (string)data_get($item, $valueKey) : Str::slug($item),
            'label' => (string)data_get($item, $labelKey),
        ])->sortBy('label')->values()->toArray();
    }
}
