<?php

namespace MSML\Tables;

use ReflectionClass;
use Illuminate\Support\Facades\Route;
use Spatie\LaravelPackageTools\Package;
use MSML\Tables\Commands\MakeTableCommand;
use Spatie\LaravelPackageTools\PackageServiceProvider;

class TablesServiceProvider extends PackageServiceProvider
{
    public function configurePackage(Package $package): void
    {
        $package
            ->name('laravel-tables')
            ->hasConfigFile('tables')
            ->hasCommand(MakeTableCommand::class);
    }

     public function packageRegistered()
    {
        $path = config('tables.table_class_path');
        $files = glob("{$path}/*.php");

        foreach ($files as $file) {
            $basename = basename($file, '.php');
            $class = "{$this->getNamespace($path)}\\{$basename}";

            if (class_exists($class)) {
                $reflection = new ReflectionClass($class);

                if ($reflection->isSubclassOf(Table::class) && !$reflection->isAbstract()) {
                    $this->app->bind("table.{$class::name()}", fn ($app) => new $class);
                }
            }
        }
    }

    public function packageBooted()
    {
        Route::bind('table', fn ($value) => app("table.$value"));
    }

    protected function getNamespace($path): string
    {
        $path = preg_replace(
            [
                '/^(' . preg_quote(base_path(), '/') . ')/',
                '/\//',
            ],
            [
                '',
                '\\',
            ],
            $path
        );

        $namespace = implode('\\', array_map(fn ($directory) => ucfirst($directory), explode('\\', $path)));

        // Remove leading backslash if present
        if (substr($namespace, 0, 1) === '\\') {
            $namespace = substr($namespace, 1);
        }

        return $namespace;
    }
}
