<?php

declare(strict_types=1);

namespace MSML\Tables\Actions;

use Generator;
use MSML\Tables\Table;
use Illuminate\Http\Request;
use Illuminate\Support\Collection;

final class ExportTableDataAction
{
    public function handle(Table $table, Request $request, Collection $columns): Generator
    {
        foreach ($table->query($request)->orderByDesc('id')->lazy(2500) as $item) {
            $row = [];

            foreach ($table->getSchema()->getColumns() as $column) {
                if (!$columns->contains('accessorKey', $column->key)) {
                    continue;
                }

                $row[$column->header] = method_exists($table, 'transformExportValue')
                    ? $table->transformExportValue($column, $item)
                    : $column->transformExportValue($item);
            }

            if (method_exists($table, 'customExportableColumns')) {
                $row = array_merge($row, $table->customExportableColumns($item));
            }

            yield $row;
        }
    }
}
