<?php

declare(strict_types=1);

namespace MSML\Tables\Schema;

use MSML\Tables\Enums\PivotInputType;

final class PivotColumnSchema
{
    /**
     * @param  array<int, array{value: string, label: string}>  $options
     */
    public function __construct(
        public readonly string $name,
        public readonly string $header,
        public readonly PivotInputType $type = PivotInputType::Number,
        public readonly mixed $default = null,
        public readonly array $options = [],
        public readonly bool $editable = true,
    ) {}

    public function toArray(): array
    {
        return [
            'name'     => $this->name,
            'header'   => $this->header,
            'type'     => $this->type->value,
            'default'  => $this->default,
            'options'  => $this->options,
            'editable' => $this->editable,
        ];
    }
}
