<?php

namespace MSML\OnlinePaymentPlatform\Models;

/**
 * Class Transaction
 */
class Transaction
{
    /** @var string */
    private $merchant_uid;

    /** @var array */
    private $products;

    /** @var string */
    private $total_price;

    /** @var string */
    private $payment_method;

    /** @var array */
    private $metadata;

    /** @var string */
    private $notify_url;

    /** @var string */
    private $return_url;

    /** @var array */
    private $address;

    /** @var string */
    private $buyer_name_first;

    /** @var string */
    private $buyer_name_last;

    /** @var string */
    private $buyer_emailaddress;

    /** @var string */
    private $shipping_costs;

    /** @var string */
    private $partner_fee;

    /**
     * @param string $merchant_uid
     * @param array $products
     * @param string $total_price
     * @param string $payment_methods
     * @param array $metadata
     * @param array $notify_url
     * @param array $return_url
     * @param Address $address
     * @param string $buyer_name_first
     * @param string $buyer_name_last
     * @param string $buyer_emailaddress
     * @param string $shipping_costs
     * @param string $partner_fee
     */
    public function __construct(
        ?string $merchant_uid,
        ?array $products,
        ?float $total_price,
        ?string $payment_method,
        ?array $metadata,
        ?string $notify_url,
        ?string $return_url,
        ?Address $address,
        ?string $buyer_name_first,
        ?string $buyer_name_last,
        ?string $buyer_emailaddress,
        ?string $shipping_costs,
        ?string $partner_fee
    ) {
        $this->merchant_uid = $merchant_uid;
        $this->products = $products;
        $this->total_price = $total_price;
        $this->payment_method = $payment_method;
        $this->metadata = $metadata;
        $this->notify_url = $notify_url;
        $this->return_url = $return_url;
        $this->address = $address->toArray();
        $this->buyer_name_first = $buyer_name_first;
        $this->buyer_name_last = $buyer_name_last;
        $this->buyer_emailaddress = $buyer_emailaddress;
        $this->shipping_costs = $shipping_costs;
        $this->partner_fee = $partner_fee;
    }

    /**
     * @return string $merchant_uid
     */
    public function getMerchantUid()
    {
        return $this->merchant_uid;
    }

    /**
     * @param string $merchant_uid
     */
    public function setMerchantUid(string $merchant_uid)
    {
        return $this->merchant_uid = $merchant_uid;
    }

    /**
     * @return array $products
     */
    public function getProducts()
    {
        return $this->products;
    }

    /**
     * @param array $products
     */
    public function setProducts(array $products)
    {
        return $this->products = $products;
    }

    /**
     * @return float $total_price
     */
    public function getTotalPrice()
    {
        return $this->total_price;
    }

    /**
     * @param float $total_price
     */
    public function setTotalPrice(string $total_price)
    {
        return $this->merchatotal_pricent_uid = $total_price;
    }

    /**
     * @return string $payment_method
     */
    public function getPaymentMethod()
    {
        return $this->payment_method;
    }

    /**
     * @param string $payment_method
     */
    public function setPaymentMethod(string $payment_method)
    {
        return $this->payment_method = $payment_method;
    }

    /**
     * @return array $metadata
     */
    public function getMetadata()
    {
        return $this->metadata;
    }

    /**
     * @param array $metadata
     */
    public function setMetadata(array $metadata)
    {
        return $this->metadata = $metadata;
    }

    /**
     * @return string $notify_url
     */
    public function getNotifyUrl()
    {
        return $this->notify_url;
    }

    /**
     * @param string $notify_url
     */
    public function setNotifyUrl(string $notify_url)
    {
        return $this->notify_url = $notify_url;
    }

    /**
     * @return string $return_url
     */
    public function getReturnUrl()
    {
        return $this->return_url;
    }

    /**
     * @param string $return_url
     */
    public function setReturnUrl(string $return_url)
    {
        return $this->return_url = $return_url;
    }

    /**
     * @return Address $address
     */
    public function getAddress()
    {
        return $this->address;
    }

    /**
     * @param Address $address
     */
    public function setAddress(Address $address)
    {
        return $this->address = $address;
    }

    /**
     * @return string $partner_fee
     */
    public function getPartnerFee()
    {
        return $this->partner_fee;
    }

    /**
     * @param string $partner_fee
     */
    public function setPartnerFee(string $partner_fee)
    {
        return $this->partner_fee = $partner_fee;
    }

    /**
     * @return array
     */
    public function toArray()
    {
        return get_object_vars($this);
    }
}
