<?php

namespace MSML\OnlinePaymentPlatform\Models;

/**
 * Class Buery
 */
class Address
{
    /** @var string */
    private $address_line_1;

    /** @var string */
    private $housenumber;

    /** @var string */
    private $housenumber_addition;

    /** @var string */
    private $zipcode;

    /** @var string */
    private $city;

    /** @var string */
    private $country;

    /**
     * @param string $address_line_1
     * @param string $housenumber
     * @param string $housenumber_addition
     * @param string $zipcode
     * @param string $city
     * @param string $country
     */
    public function __construct(
        ?string $address_line_1,
        ?string $housenumber,
        ?string $housenumber_addition,
        ?string $zipcode,
        ?string $city,
        ?string $country
    ) {
        $this->address_line_1 = $address_line_1;
        $this->housenumber = $housenumber;
        $this->housenumber_addition = $housenumber_addition;
        $this->zipcode = $zipcode;
        $this->city = $city;
        $this->country = $country;
    }

    /**
     * @param string $address_line_1
     */
    public function setAddressLine1(string $address_line_1)
    {
        return $this->address_line_1 = $address_line_1;
    }

    /**
     * @return string $address_line_1
     */
    public function getAddressLine1()
    {
        return $this->address_line_1;
    }

    /**
     * @param string $housenumber
     */
    public function getHouseNumber(string $housenumber)
    {
        return $this->housenumber = $housenumber;
    }

    /**
     * @return string $housenumber
     */
    public function setHouseNumber()
    {
        return $this->housenumber;
    }

    /**
     * @param string $housenumber_addition
     */
    public function setHouseNumberAddition(string $housenumber_addition)
    {
        return $this->housenumber_addition = $housenumber_addition;
    }

    /**
     * @return string $housenumber_addition
     */
    public function getHouseNumberAddition()
    {
        return $this->housenumber_addition;
    }

    /**
     * @param string $zipcode
     */
    public function setZipcode(string $zipcode)
    {
        return $this->zipcode = $zipcode;
    }

    /**
     * @return string $zipcode
     */
    public function getZipcode()
    {
        return $this->zipcode;
    }

    /**
     * @param string $city
     */
    public function setCity(string $city)
    {
        return $this->city = $city;
    }

    /**
     * @return string $city
     */
    public function getCity()
    {
        return $this->city;
    }

    /**
     * @param string $country
     */
    public function setCountry(string $country)
    {
        return $this->country = $country;
    }

    /**
     * @return string $country
     */
    public function getCountry()
    {
        return $this->country;
    }

    /**
     * @return array
     */
    public function toArray()
    {
        return get_object_vars($this);
    }
}
