<?php

namespace MSML\OnlinePaymentPlatform;

use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\Http;
use MSML\OnlinePaymentPlatform\Models\Merchant;

class OnlinePaymentPlatform
{
    /**
     * Http client
     *
     * @var Illuminate\Support\Facades\Http;
     */
    private $httpClient;

    /**
     * Create a new instance.
     *
     * @return void
     */
    public function __construct()
    {
        $baseUri = config('online-payment-platform.endpoint');
        $token = config('online-payment-platform.api_key');

        // Rest client
        $this->httpClient = Http::withOptions([
            'base_uri' => $baseUri,
        ])->withToken($token);
    }

    /**
     * Get iDeal issuers.
     *
     * @return JsonResponse
     */
    public function idealIssuers()
    {
        $response = $this->httpClient->get('ideal_issuers');

        return $response->json();
    }

    /**
     * Get payment methods.
     *
     * @return JsonResponse
     */
    public function paymentMethods()
    {
        $response = $this->httpClient->get('payment_methods');

        return $response->json();
    }

    /**
     * Get merchant based on uid.
     *
     * @param  string  $merchentUid
     * @return JsonResponse
     */
    public function merchant($merchentUid)
    {
        $response = $this->httpClient->get('merchants/' . $merchentUid);

        return $response->json();
    }

    /**
     * Create a new merchant.
     *
     * @param  Merchant  $merchant
     * @return JsonResponse
     */
    public function createMerchant(Merchant $merchant)
    {
        $response = $this->httpClient->post('merchants', $merchant->toArray());

        return $response->json();
    }

    /**
     * Update the given merchant.
     *
     * @param  string  $merchentUid
     * @param  Merchant  $merchant
     * @return JsonResponse
     */
    public function updateMerchant($merchentUid, Merchant $merchant)
    {
        $response = $this->httpClient->post('merchants/' . $merchentUid, $merchant->toArray());

        return $response->json();
    }
}
