<?php

namespace MSML\OnlinePaymentPlatform;

use Spatie\LaravelPackageTools\Package;
use Spatie\LaravelPackageTools\PackageServiceProvider;

class OnlinePaymentPlatformServiceProvider extends PackageServiceProvider
{
    public function configurePackage(Package $package): void
    {
        /*
         * This class is a Package Service Provider
         *
         * More info: https://github.com/spatie/laravel-package-tools
         */
        $package
            ->name('online-payment-platform-laravel')
            ->hasConfigFile('config');
    }

    /**
     * Register function
     *
     * @return void
     */
    public function register()
    {
        $this->mergeConfigFrom(__DIR__.'/../config/config.php', 'online-payment-platform');
    }

    /**
     * Boot function
     *
     * @return void
     */
    public function boot()
    {
        if ($this->app->runningInConsole()) {
            $this->publishes([
            __DIR__.'/../config/config.php' => config_path('online-payment-platform.php'),
            ], 'config');
        }
    }
}
