<?php

namespace MSML\OnlinePaymentPlatform\Models;

/**
 * Class Merchant
 */
class Merchant
{
    /** @var string */
    private $emailaddress;

    /** @var string */
    private $country;

    /** @var string */
    private $phone;

    /** @var string */
    private $notify_url;

    /** @var string */
    private $type;

    /** @var string */
    private $coc_nr;

    /**
     * @param string $emailaddress
     * @param string $country
     * @param string $phone
     * @param string $notify_url
     * @param string $type
     * @param string $coc_nr
     */
    public function __construct(string $emailaddress, string $country, string $phone, string $notify_url, string $type = 'consumer', ?string $coc_nr = null)
    {
        $this->emailaddress = $emailaddress;
        $this->country = $country;
        $this->phone = $phone;
        $this->type = $type;
        $this->notify_url = $notify_url;
        $this->coc_nr = $coc_nr;
    }

    /**
     * @return string $emailaddress
     */
    public function getEmailaddress()
    {
        return $this->emailaddress;
    }

    /**
     * @param string $emailaddress
     */
    public function setEmailaddress(string $emailaddress)
    {
        return $this->emailaddress = $emailaddress;
    }

    /**
     * @return string $country
     */
    public function getCountry()
    {
        return $this->country;
    }

    /**
     * @param string $country
     */
    public function setCountry(string $country)
    {
        return $this->country = $country;
    }

    /**
     * @return string $phone
     */
    public function getPhone()
    {
        return $this->phone;
    }

    /**
     * @param string $phone
     */
    public function setPhone(string $phone)
    {
        return $this->phone = $phone;
    }

    /**
     * @return string $notify_url
     */
    public function getNotifyUrl()
    {
        return $this->notify_url;
    }

    /**
     * @param string $notify_url
     */
    public function setNotifyUrl(string $notify_url)
    {
        return $this->notify_url = $notify_url;
    }

    /**
     * @return string $cocNr
     */
    public function getCocNr()
    {
        return $this->coc_nr;
    }

    /**
     * @param string $cocNr
     */
    public function setCocNr(string $coc_nr)
    {
        return $this->coc_nr = $coc_nr;
    }

    /**
     * @return string $type
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * @param string $type
     */
    public function setType(string $type)
    {
        return $this->type = $type;
    }

    /**
     * @return array
     */
    public function toArray()
    {
        return get_object_vars($this);
    }
}
