<?php

namespace MSML\OnlinePaymentPlatform\Models;

/**
 * Class Product
 */
class Product
{
    /** @var string */
    private $name;

    /** @var float */
    private $price;

    /** @var int */
    private $quantity;

    /**
     * @param string $name
     * @param float $price
     * @param int $quantity
     */
    public function __construct(string $name, float $price, int $quantity)
    {
        $this->name = $name;
        $this->price = $price;
        $this->quantity = $quantity;
    }

    /**
     * @return string $name
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @param string $name
     */
    public function setName(string $name)
    {
        return $this->name = $name;
    }

    /**
     * @return float $price
     */
    public function getPrice()
    {
        return $this->price;
    }

    /**
     * @param float $price
     */
    public function setPrice(float $price)
    {
        return $this->price = $price;
    }

    /**
     * @return int $quantity
     */
    public function getQuantity()
    {
        return $this->quantity;
    }

    /**
     * @param int $quantity
     */
    public function setQuantity(int $quantity)
    {
        return $this->quantity = $quantity;
    }

    /**
     * @return array
     */
    public function toArray()
    {
        return get_object_vars($this);
    }
}
