<?php

namespace MSML\SignInWithGoogle;

use Google\Client;
use Illuminate\Support\Arr;
use SocialiteProviders\Manager\OAuth2\User;
use SocialiteProviders\Manager\OAuth2\AbstractProvider;
use MSML\SignInWithGoogle\Exceptions\InvalidTokenException;
use MSML\SignInWithGoogle\Exceptions\DisallowedMethodException;

class Provider extends AbstractProvider
{
    public const IDENTIFIER = 'SIGN-IN-WITH-GOOGLE';

    /**
     * @throws DisallowedMethodException
     */
    public function redirect()
    {
        throw new DisallowedMethodException();
    }

    /**
     * @throws DisallowedMethodException
     */
    public function refreshToken($refreshToken)
    {
        throw new DisallowedMethodException();
    }

    protected function getAuthUrl($state)
    {
        //
    }

    protected function getTokenUrl()
    {
        //
    }

    /**
     * @throws InvalidTokenException
     */
    public function getUserByToken($token)
    {
        $this->stateless = true;

        $client = new Client([
            'client_id'     => config('services.sign-in-with-google.client_id'),
            'client_secret' => config('services.sign-in-with-google.client_secret'),
        ]);

        $payload = $client->verifyIdToken($token);

        if (!$payload) {
            throw new InvalidTokenException();
        }

        return $this->mapUserToObject($payload);
    }

    protected function mapUserToObject(array $user)
    {
        return (new User())->setRaw($user)->map([
            'id'             => Arr::get($user, 'sub'),
            'name'           => Arr::get($user, 'name'),
            'first_name'     => Arr::get($user, 'given_name'),
            'last_name'      => Arr::get($user, 'family_name'),
            'email'          => Arr::get($user, 'email'),
            'email_verified' => Arr::get($user, 'email_verified'),
            'avatar'         => Arr::get($user, 'picture'),
            'host_domain'    => Arr::get($user, 'hd'),
        ]);
    }
}
