# Sign In with Google (Socialite)

## Installation
```bash
composer require msml/sign-in-with-google
```

## Configuration

Configure the environment variables for your application:

```dotenv
# .env

SIGN_IN_WITH_GOOGLE_CLIENT_ID=foobar.apps.googleusercontent.com
SIGN_IN_WITH_GOOGLE_CLIENT_SECRET=FOOBAR-L1kjjn2HkcZzLJnkzHFdLyd
SIGN_IN_WITH_GOOGLE_REDIRECT=/auth/sign-in-with-google
```

Add the following array to your `config/services.php` file:

```php
# config/services.php

'sign-in-with-google' => [
    'client_id'     => env('SIGN_IN_WITH_GOOGLE_CLIENT_ID'),
    'client_secret' => env('SIGN_IN_WITH_GOOGLE_CLIENT_SECRET'),
    'redirect'      => env('SIGN_IN_WITH_GOOGLE_REDIRECT'),
],
```

Register the service provider

```php
MSML\SignInWithGoogle\SignInWithGoogleServiceProvider::class,
```

Register the route to receive the callback:

```php
Route::post('auth/sign-in-with-google', SignInWithGoogleController::class)->name('sign-in-with-google');
```

Add your logic to handle the callback, for example in your SignInWithGoogle controller:

```php
$user = Socialite::driver('sign-in-with-google')->getUserByToken($request->input('credential'));

$user = User::updateOrCreate([
    'email' => $user['email'],
], [
    'first_name' => $user->attributes['first_name'],
    'last_name'  => $user->attributes['last_name'],
]);

Auth::login($user);
```

Add the Google Client library to the `<head></head>` of your layout:

```html
<script src="https://accounts.google.com/gsi/client" async defer></script>
```
