<?php

namespace MSML\SignInWithGoogle;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Event;
use Illuminate\Support\Facades\Request;
use SocialiteProviders\Manager\SocialiteWasCalled;

class SignInWithGoogleServiceProvider extends ServiceProvider
{
    public function boot(): void
    {
        Event::listen(SocialiteWasCalled::class, SignInWithGoogleExtendSocialite::class);

        $this->macros();
    }

    private function macros(): void
    {
        Request::macro('canSignInFromGoogle', function () {
            if (!config('services.sign-in-with-google.client_id')) {
                return false;
            }

            if (!config('services.sign-in-with-google.whitelist.enabled')) {
                return true;
            }

            return in_array(
                $this->header('X-Forwarded-For') ?? $this->ip(),
                config('services.sign-in-with-google.whitelist.ips')
            );
        });
    }
}
